;*****************************************************************************************************************
;Source File Name:
;		oscres.jss
;Author's Name:
;		Ben Key 
;Description:
;		JFW Script file for oscres.dll, the executable program for the AOL instant messenger logon.
;		Oscres.dll is also used for various other dialog boxes found in AIM.
;Included Header Files:
;	hjconst.jsh
;		default HJ constants 
;	hjglobal.jsh
;		default HJ global variables
;	aim.jsh
;		Global header file for the entire AIM project.  Contains all constants and globals used
;		in the AIM project.
;	aim.jsm
;		Global Message file for the entire AIM project.
;
;*****************************************************************************************************************
;															MODIFICATION LOG
;															================
; 06/23/1999		Ben Key
;	Project started
; 06/25/1999		Ben Key
;	ScreenSensitiveHelp added 
; 06/25/1999		Ben Key
;	ScriptFileName added
; 06/29/1999		Ben Key
;	HotKeyHelp added
; 07/01/1999		Ben Key
;	Added support for the following dialog boxes in AIM:
;		1.		Change Password
;		2.		Save Buddy List
;		3.		Format Screen Name
;		4.		Update E-Mail Address
;		by modifying the function SayFocusedWindow ()
;*****************************************************************************************************************
include "hjconst.jsh"			; default HJ constants 
include "hjglobal.jsh"		; default HJ global variables
Include "AIM.jsh"
Include "AIM.jsm"

;*****************************************************************************************************************
;Function:	
;		Void ScreenSensitiveHelpForKnownClasses (int nSubTypeCode)
;Author's Name:
;		Ben Key
;Description:
;		This function is based upon the screen scensitive help for known classes function found
;		in default.jss.  It is used to customize the messages that are spoken when screen 
;		sensitive help is called for certain controls.  Messages for the following controls have been 
;		customized:
;			1. buttons		Now say "This is the {button name} button" rather than "this is a button."
;			2. Read Only edit
;Parameters:
;		int nSubTypeCode		The window subtype code of the window that currently has focus
;Globals
;	Used:
;	Modified:
;Return Value:		Void
;Other Information:
;*****************************************************************************************************************
;
;*****************************************************************************************************************
;															MODIFICATION LOG
;															================
; 06/23/1999		Ben Key
;	Project started
;*****************************************************************************************************************
Void Function ScreenSensitiveHelpForKnownClasses (int nSubTypeCode)
var  int TheTypeCode, string RealName, String strTest
let theTypeCode = nSubTypeCode
; Following lines customized for AIM
if (TheTypeCode == WT_BUTTON) then ;#1
	Say (kcmsg001, ot_help) ;"This is the"
	Say (GetWindowName (GetCurrentWindow ()), ot_help)
	Say (kcmsg001a, ot_help) ;"button"
	Say (kcmsg002, ot_help) ;"Use enter to activate it"
	Say (kcmsg003, ot_help) ;" Use Tab to move to the next Control"
	If (GetWindowName (GetCurrentWindow ()) == wnRegisterNew) then
		Say (schmsg_Common + schmsg_wnRegisterNew, ot_help)
	ElIf (GetWindowName (GetCurrentWindow ()) == wnUseAOL) then
		Say (schmsg_Common + schmsg_wnUseAOL, ot_help)
	EndIf
	Return
ElIf (TheTypeCode == WT_READONLYEDIT) then ;#43
		Say (schReadOnly1, ot_help)
		Say (schReadOnly2, ot_help)
;		Say (kcmsg132, ot_help) ;"This text is reed only"
;		Say (kcmsg133, ot_help) ;"you can navigate and read text with the jaws cursor"
;		Say (kcmsg134, ot_help) ;"but you cannot edit the text"
		Return
;WT_EDITCOMBO = 41
ElIf (TheTypeCode == WT_EDITCOMBO) then ;#41
	Say (kcmsg129, ot_help) ;"This is an edit Combo box"
	Say (kcmsg005, ot_help) ;"type in a value or use alt plus down arrow to open the list box"
	Say (kcmsg005b, ot_help); " use the arrow keys to move between the items"
	Say (kcmsg005c, ot_help); "use alt plus up arrow or Escape to close the list box"
	Say (kcmsg006, ot_help) ;"Use the Tab key to move to the next Control"
;	Say (kcmsg150, ot_help) ;" previously selected items"
	Return
endif
ScreenSensitiveHelpForKnownClasses (nSubTypeCode)
Return
; Above lines customized for AIM
EndFunction

Function FocusChangedEvent (handle FocusWindow, handle PrevWindow)
var handle RealWindow, string RealWindowName, handle AppWindow
let RealWindow = GetRealWindow (FocusWindow)
let RealWindowName = GetWindowName (RealWindow)
let AppWindow = GetAppMainWindow (FocusWindow)
if (GlobalPrevApp != AppWindow && AppWindow != FocusWindow) then
  ; we've switched to a different app main window,
  ; and it does not have the focus, so announce it
	; Customize speaking of the Change Password dialog box.  Calling 
	;	SayWindowTypeAndText (AppWindow) here will cause "Change 
	;	Password:" to be spoken before the dialog static text.  The same applies
	; to the "Format Screen Name" and the "Update E-mail Address" dialogs
	If ((RealWindowName == wnChangePassword)
		|| (RealWindowName == wnFormatScreenName)
		|| (RealWindowName == wnUpdateEmail)) then
		Say (GetWindowName (GetRealWindow (GetFocus ())), ot_message)
		Say (msgDialog, ot_message)
	Else
	  SayWindowTypeAndText (AppWindow)
	EndIf
endif
If ((GlobalPrevRealName != RealWindowName) ; name has changed
  || (GlobalPrevReal != RealWindow)) then ; or handle has changed, then
  If ((RealWindow != AppWindow) && (RealWindow != FocusWindow)) then
    SayWindowTypeAndText (RealWindow)
  endif
EndIf
let GlobalFocusWindow = FocusWindow
if (GlobalPrevFocus != focusWindow) then
  SayFocusedWindow () ; will use global variable GlobalFocusWindow
else
  SayFocusedObject ()
EndIf
;above perform will return here to finish this routine
;now set all the global variables for next time.
let GlobalPrevReal = RealWindow
let GlobalPrevRealName = RealWindowName
let GlobalPrevApp = AppWindow
let GlobalPrevFocus = FocusWindow
EndFunction

Void Function SayHighLightedText (handle hwnd, string buffer)
Var String rWinTitle, String hwndClass
Let rWinTitle = GetWindowName (GetRealWindow (GetFocus ()))
Let hwndClass = GetWindowClass (hwnd)
If (GlobalMenuMode != MENU_INACTIVE) then
	SayHighLightedText (hwnd, buffer)
ElIf (IsSelectItemDlg ()) then
	SayHighLightedText (hwnd, buffer)
ElIf (IsSelectScriptDlg ()) then
	SayHighLightedText (hwnd, buffer)
ElIf (GlobalMenuMode != MENU_INACTIVE) then
	SayHighLightedText (hwnd, buffer)
ElIf (hwndClass == wcSysTabControl) then
	If (numTimes == 0) then
		Say (buffer, ot_buffer)
		Let numTimes = 1
	ElIf (numTimes != 0) then
		Return
	EndIf
Else
	SayHighLightedText (hwnd, buffer)
EndIf
EndFunction

Void Function AutoStartEvent ()
Let numTimes = 0
EndFunction

;*****************************************************************************************************************
;Function:	
;		Void Function SayFocusedWindow ()
;Author's Name:
;		Ben Key
;Description:
;		This function is used to customize how JFW reads certain windows encountered in 
;		AOL Instant Messenger.  The windows customized are as follows:
;		1.  New User Registration
;Parameters:
;		None
;Globals
;	Used:
;	Modified:
;Return Value:		Void
;Other Information:
;*****************************************************************************************************************
;
;*****************************************************************************************************************
;															MODIFICATION LOG
;															================
; 06/23/1999		Ben Key
;	Project started
;*****************************************************************************************************************
Void Function SayFocusedWindow ()
Var Handle hTarget, String rWinTitle, Handle rWin, Handle tmpHandle
Let rWin = GetRealWindow (GetFocus ())
Let rWinTitle = GetWindowName (rWin)
If ((GlobalPrevRealName != rWinTitle) ; name has changed
  || (GlobalPrevReal != rWin)) then ; or handle has changed, then
	If (rWinTitle == wnInformation) then
		Let tmpHandle = FindDescendantWindow (rWin, cID_InfoTextParent)
		If (tmpHandle) then
			Let hTarget = GetFirstChild (tmpHandle)
			If (hTarget) then
				SayWindow (hTarget, READ_EVERYTHING)
			EndIf
			If (GetWindowClass (GetCurrentWindow ()) == wcAte32
				&& GetControlID (GetParent (GetCurrentWindow ())) == cID_InfoTextParent) then
				Return
			Else
				SayWindowTypeAndText (GetCurrentWindow ())
			EndIf
		EndIf
	; Customize the speaking of the New User Registration window so that the static text window 
	; that appears above the Register New Sreen Name button gets spoken automatically.  Also 
	; applies to Save Buddy List dialog and the Update E-mail Address dialog
	ElIf ((rWinTitle == wnNewUserReg)
		|| (rWinTitle == wnSaveList)
		|| (rWinTitle == wnUpdateEmail)) then
		; The first child window of the real window has a window class of #32770.  The static 
		; window of interest is a descendant  window of this window.  It has a control ID of 65535.  
		; Use FindDescendantWindow to find its window handle and use SayWindow to read its 
		; contents.  Then speak the name of the active control.
		Let hTarget = FindDescendantWindow (rWin, cID_NewUserA)
		If (hTarget) then 
			SayWindow (hTarget, READ_EVERYTHING) 
		EndIf
		If (rWinTitle == wnSaveList && GetCurrentControlID () == cID_CheckItemsToSave) then
			Say (wnCheckItemsToSave, ot_message)
		Else
			SayWindowTypeAndText (GetCurrentWindow ())
		EndIf
		Return
	;	Customize speaking of the Change Password dialog.  The first child window of the real 
	; window has a window class of #32770. All the dialog box controls are child windows of this 
	; window.  The dialog box is composed of three edit boxes, each with a static text window 
	; containing its label.  All the static text windows have the same control ID, 65535.
	; The static text window that needs to be spoken automatically can be identified by the string 
	; "To change your password."  	Use FindDescendantWindow (...) to find the first static 
	; window, and then walk through the window hierarchy until finding a window that contains 
	; the appropriate string.  Then speak the window followed by the active control.
	ElIf (rWinTitle == wnChangePassword) then
		Let tmpHandle = FindDescendantWindow (rWin, cID_NewUserA)
		If (tmpHandle) then
			While (StringContains (GetWindowText (tmpHandle, FALSE), strToChangePassword) == 0 
				&& tmpHandle != 0)
				Let tmpHandle = GetNextWindow (tmpHandle)
			EndWhile
			SayWindow (tmpHandle, READ_EVERYTHING)
			SayWindowTypeAndText (GlobalFocusWindow)
		Else
				SayWindowTypeAndText (GlobalFocusWindow)
		EndIf
		Return
	; Customize speaking of the Format Screen Name dialog.  The first child window of the real 
	; window has a window class of #32770.  All the dialog box controls are child windows of this
	; window.  The dialog box is composed of one edit box, two buttons, and two static text 
	; windows.  The first static text window is the label for the edit box.  The second static 
	; window ( the one that needs to be	spoken automatically) is seperated from the first by 
	;	several controls,	Use FindDescendantWindow (...) to find the first static window, and then 
	; walk through the window hierarchy until finding the second static window.  Then speak the 
	; window followed by the active control.
	ElIf (rWinTitle == wnFormatScreenName) then
		Let tmpHandle = FindDescendantWindow (rWin, cID_NewUserA)
		Let tmpHandle = GetNextWindow (tmpHandle)
		If (tmpHandle) then
			While (GetControlID (tmpHandle) != cID_NewUserA && tmpHandle != 0)
				Let tmpHandle = GetNextWindow (tmpHandle)
			EndWhile
			SayWindow (tmpHandle, READ_EVERYTHING)
			SayWindowTypeAndText (GlobalFocusWindow)
		Else
			SayWindowTypeAndText (GlobalFocusWindow) 
		EndIf
		Return
	EndIf
Else
	If (rWinTitle == wnSaveList && GetCurrentControlID () == cID_CheckItemsToSave) then
		Say (wnCheckItemsToSave, ot_message)
		If (GetCharacterAttributes () & ATTRIB_HIGHLIGHT) then
			SayChunk ()
		EndIf
	ElIf (rWinTitle == wnInformation
		&& GetWindowClass (GetCurrentWindow ()) == wcAte32
		&& GetControlID (GetParent (GetCurrentWindow ())) == cID_InfoTextParent) then
		Say (rWinTitle, ot_message)
		SayWindow (GetCurrentWindow (), READ_EVERYTHING)
		Return
	ElIf (GetWindowClass (GetCurrentWindow ()) == wcOscarButton) then
		Say (GetWindowName (GetCurrentWindow ()), ot_message)
		Say (msgButton, ot_message)
	Else
		SayWindowTypeAndText (GlobalFocusWindow) 
	EndIf
EndIf
EndFunction

;*****************************************************************************************************************
;Script:	
;		Script ScreenSensitiveHelp ()
;Author's Name:
;		Ben Key
;Description:
;		This script is used to customize the messages spoken by screen sensitive help for windows 
;		that are not sufficiently covered in ScreenSensitiveHelpForKnownClasses.
; 		Custom windows handled
;		1.		Windows with a window class of _Oscar_IconBtn.
;Parameters:
;		None
;Globals
;	Used:
;	Modified:
;Return Value:		None
;Other Information:
;*****************************************************************************************************************
;
;*****************************************************************************************************************
;															MODIFICATION LOG
;															================
; 06/23/1999		Ben Key
;	Project started
;*****************************************************************************************************************
Script ScreenSensitiveHelp ()
var  handle WinHandle, int TheTypeCode, String TheClass, String strTemp
; No Application specific help topic has been created for AOL Instant Messenger thus far.  The 
; following four lines will need to be un-commented when an application specific help topic 
; has been written.
;if (IsSameScript ()) then
;	AppFileTopic()
;	return
;EndIf
if (GlobalMenuMode > 0) then
	PerformScript ScreenSensitiveHelp()
	return
EndIf
; Initialize the variables WinHandle, TheTypeCode, and The Class
let WinHandle = GetCurrentWindow ()
let TheTypeCode = GetWindowSubTypeCode (WinHandle)
let TheClass = GetWindowClass (WinHandle)
Let strTemp = ""
; Handle all custom screen sensitive help messages.  Be certain to place a return statement 
; at the end of each condition.
;	Windows with a window class of _Oscar_IconBtn.
If (TheClass == wcOscarButton) then
	let strTemp = GetWindowName (GetCurrentWindow ())
	Say (kcmsg001, ot_help) ;"This is the"
	Say (strTemp, ot_help)
	Say (kcmsg001a, ot_help) ;"button"
	Say (kcmsg002, ot_help) ;"Use enter to activate it"
	Say (kcmsg003, ot_help) ;" Use Tab to move to the next Control"
	Return
EndIf
; For any window or control not covered above, call the default functions
if (TheTypeCode < 1) then
	ScreenSensitiveHelpForUnknownClasses()  ; handle unknown window types and classes
else
	ScreenSensitiveHelpForKnownClasses (theTypeCode); known types
EndIf
EndScript

;*****************************************************************************************************************
;Script:	
;		Script  ScriptFileName()
;Author's Name:
;		Ben Key
;Description:
;	This script is designed to say the script and application name by calling the function
;  ScriptAndAppNames with the string parameter AOL Instant messenger 
;Parameters:
;		None
;Globals
;	Used:				None
;	Modified:		None
;Return Value:		None
;Other Information:
;*****************************************************************************************************************
;
;*****************************************************************************************************************
;															MODIFICATION LOG
;															================
; 06/29/1999		Ben Key
;	Script created
;*****************************************************************************************************************
Script  ScriptFileName()
ScriptAndAppNames(msgOscresScriptFile) ;msgScriptFile = "AOL Instant messenger setup",
EndScript

;*****************************************************************************************************************
;Script:	
;		Script  HotKeyHelp ()
;Author's Name:
;		Ben Key
;Description:
;	This script is designed to say the hot keys available in the Sign On dialog.  The 
;	DefaultHokKeyHelpLoop () fails to obtain any hotkeys for this window.  An attempt to modify 
;	the DefaultHotKeyHelpLoop () so that it would work for this dialog failed.  Therefore, at least 
;	for now, the hot keys are in the form of hard coded messages.
;Parameters:
;		None
;Globals
;	Used:				None
;	Modified:		None
;Return Value:		None
;Other Information:
;*****************************************************************************************************************
;
;*****************************************************************************************************************
;															MODIFICATION LOG
;															================
; 06/23/1999		Ben Key
;	Script created
;*****************************************************************************************************************
Script HotKeyHelp ()
Var String rWinTitle, Handle hTarget
Let rWinTitle = GetWindowName (GetRealWindow (GetFocus ()))
Let hTarget = FindDescendantWindow (GetRealWindow (GetFocus ()), 131)
; The default function HotKeyDefaultLoop () will not work to list the hot keys for the AIM sign on 
;	dialog.  It is also not possible to modify the function so that it will work with this dialog box.  
;	This is due to the fact that GetHotKey () fails to obtain a hot key string for the _Oscar_IconBtn 
;	controls, which are the only controls in this dialog box that have accelerator keys.  
;	Therefore, it was necessary to hard code the hot key messages for this dialog.  If any other 
; window is active, the default HotKeyHelp () script is performed.
If (rWinTitle == wnSignOn) then
	Say (hkmsg_Help, ot_help)
	Say (hkmsg_Setup, ot_help)
	If (IsWindowDisabled (hTarget) == FALSE) then
		Say (hkmsg_SignOn, ot_help)
	EndIf
Else
	PerformScript HotKeyHelp()
EndIf
EndScript

Script  SayWindowPromptAndText()
;SayWindowTypeAndText(GetCurrentWindow())
SayFocusedWindow ()
EndScript